//
//  GSVodObject.h
//  PlayerSDK
//
//  Created by 张俞 on 2023/8/8.
//  Copyright © 2023 Geensee. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "VodPlayer.h"
#import "GSVodManager.h"

NS_ASSUME_NONNULL_BEGIN

@interface GSVodObject : NSObject
/// 本地点播缓存文件的最大值 默认是10,需要再createVodPlayerWithDownItem方法前调用
@property (nonatomic, assign) int cacheNum_Max;

/// 是否是flv
@property (nonatomic, assign) BOOL isFlv;
/// 是否是https请求
@property (nonatomic, assign) BOOL isHttps;
/// 是否采用硬件解码
@property (assign, nonatomic) BOOL hardwareAccelerate;

/// 音频session设置AVAudioSessionCategoryOptions 默认为 AVAudioSessionCategoryOptionDefaultToSpeaker |AVAudioSessionCategoryOptionAllowBluetooth
@property (nonatomic, assign) AVAudioSessionCategoryOptions sessionCategoryOption;

/// 是否自动请求点播件的开始时间、结束时间、文件大小等额外信息
@property (nonatomic, assign) BOOL isAutoRequestMore;


/// 播放器
@property (nonatomic, strong) VodPlayer *player;
/// 代理对象
@property (nonatomic, weak) id<GSVodManagerDelegate> delegate;

/**
仅获取点播件信息
@param param 需要下载item的param信息
@param block 获取信息回调,异步请求,多次调用并不保证时序性
*/
- (void)request:(GSConnectInfo *)param completion:(void(^)(downItem *item,GSVodWebaccessError type))block;

/// 创建点播播放器
- (void)createVodPlayerWithDownItem:(nullable downItem *)item VodPlayDelegate:(nullable id<VodPlayDelegate>)delegate;

/// 销毁点播播放器
- (void)destroyVodPlayer;


/// 获取点播在线观看的缓存文件夹路径
+ (NSString *)getVodOnlineFilesPath;

/// 设置默认音频会话 AVAudioSessionCategoryPlayback：AVAudioSessionCategoryOptionMixWithOthers|AVAudioSessionCategoryOptionAllowBluetooth|AVAudioSessionCategoryOptionDefaultToSpeaker ： AVAudioSessionModeDefault
+ (BOOL)vodSetDefaultAudioSessionCategory;

@end

NS_ASSUME_NONNULL_END
